<?php
error_reporting(E_ALL);
require_once 'HTTP/Request.php';

if (! isset($_SERVER['argv'][1])) {
    die("Nie zosta przekazany aden adres URL.\n");
}

$url = $_SERVER['argv'][1];

// Pobranie strony
$r = load_with_http_request($url);

if (! strlen($r->getResponseBody())) {
    die("Nie mona pobra strony spod adresu $url");
}

// Przeksztacenie do kodu XML  ze wzgldu na atwo analizowania
$opts = array('output-xhtml' => true,
              'numeric-entities' => true);
$xml = tidy_repair_string($r->getResponseBody(), $opts);
$doc = new DOMDocument();
$doc->loadXML($xml);
$xpath = new DOMXPath($doc);
$xpath->registerNamespace('xhtml','http://www.w3.org/1999/xhtml');

// Wyznaczenie bazowego adresu URL dla odsyaczy wzgldnych
$baseURL = '';
// Sprawdzenie, czy w kodzie strony zosta zamieszczony element <base href=""/>
$nodeList = $xpath->query('//xhtml:base/@href');
if ($nodeList->length == 1) {
    $baseURL = $nodeList->item(0)->nodeValue;
}
// Brak elementu <base href=""/> - bazowy adres URL zostanie wyznaczony na podstawie $url
else {
    $URLParts = parse_url($r->_url->getURL());
    if (! (isset($URLParts['path']) && strlen($URLParts['path']))) {
        $basePath = '';
    } else {
        $basePath = preg_replace('#/[^/]*$#','',$URLParts['path']);
    }
    if (isset($URLParts['username']) || isset($URLParts['password'])) {
        $auth = isset($URLParts['username']) ? $URLParts['username'] : '';
        $auth .= ':';
        $auth .= isset($URLParts['password']) ? $URLParts['password'] : '';
        $auth .= '@';
    } else {
        $auth = '';
    }
    $baseURL = $URLParts['scheme'] . '://' . 
               $auth . $URLParts['host'] .
               $basePath;
}

// Przechowanie informacji o sprawdzonych odsyaczach, aby nie wystpi przypadek
// powtrnego odwoania do tego samego adresu
$seenLinks = array();

// Wyodrbnienie wszystkich odsyaczy
$links = $xpath->query('//xhtml:a/@href');

foreach ($links as $node) {
    $link = $node->nodeValue;
    // Zamiana adresw wzgldnych na bezwgldne
    if (! preg_match('#^(http|https|mailto):#', $link)) {
        if (((strlen($link) == 0)) || ($link[0] != '/')) {
            $link = '/' . $link;
        }
        $link = $baseURL . $link;
    }
    // Pominicie odsyacza, ktry by wczeniej analizowany
    if (isset($seenLinks[$link])) {
        continue;
    }
    // Oznaczenie odsyacza jako sprawdzonego
    $seenLinks[$link] = true;
    // Wywietlenie informacji o sprawdzanym odsyaczu
    print $link.': ';
    flush();
    
    $r = load_with_http_request($link, 'HEAD');
    // Okrelenie dalszego sposobu dziaania na podstawie kodu odpowiedzi
    // Odpowied o kodzie 2xx oznacza, e odsyacz jest poprawny
    if (($r->getResponseCode() >= 200) && ($r->getResponseCode() < 300)) {
        $status = 'OK';
    }
    // Odpowied o kodzie 3xx oznacza przeniesienie strony w inne miejsce
    else if (($r->getResponseCode() >= 300) && ($r->getResponseCode() < 400)) {
        $status = 'Przeniesiono';
        if (strlen($location = $r->getResponseHeader('location'))) {
            $status .= ": $location";
        }
    }
    // Inne kody odpowiedzi oznaczaj bd odsyacza
    else {
        $status = "Bd: {$r->getResponseCode()}";
    }
    if (strlen($lastModified = $r->getResponseHeader('last-modified'))) {
        $status .= "; Ostatnia modyfikacja: $lastModified";
    }
    // Wywietlenie informacji na temat odsyacza
    print "$status\n";
}

function load_with_http_request($url, $method = 'GET') {
    if ($method == 'GET') {
        $done = false; $max_redirects = 10;
        while ((! $done) && ($max_redirects > 0)) {
            $r = new HTTP_Request($url);
            $r->sendRequest();
            $responseCode = $r->getResponseCode();
            if (($responseCode >= 300) && ($responseCode < 400) &&
                strlen($location = $r->getResponseHeader('location'))) {
                    $url = $location;
                    $max_redirects--;
            } else {
                $done = true;
            }
        }
    } else {
        $r = new HTTP_Request($url);
        $r->setMethod(HTTP_REQUEST_METHOD_HEAD);
        $r->sendRequest();
    }
    return $r;
}
?>
